/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.UpdatesErrorIds;
import com.ibm.hwmca.fw.bridge.NativeBridge;
import com.ibm.hwmca.fw.bridge.NativeBridgeException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.NativeProcessParameters;
import com.ibm.hwmca.fw.util.ObjectDumperAttributes;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public class PatchTrace
implements UpdatesErrorIds {
    private static final int COMMAND_START = 0;
    private static final int COMMAND_CREATE = 1;
    private static final int COMMAND_DELETE = 2;
    private static final int COMMAND_FLUSH = 3;
    private static final int COMMAND_PURGE = 4;
    private static final int COMMAND_QUIT = 5;
    private static Object traceGate = new Object();
    private static boolean isLibraryLoaded = false;
    private static boolean isObjectDumperAvailable = false;
    private static Object objectDumper = null;
    private static Method dumpObject = null;
    private static Object[] dumpObjectArgs = new Object[2];
    private static NativeBridge bridge;
    private static final FrameworkClassLogInfo logInfo;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$util$ObjectDumperAttributes;

    public static void trace(String traceMask, String prefix, Object trace, ObjectDumperAttributes attribs) {
        if (traceMask == null || traceMask.length() < 8) {
            PatchTrace.trace("XFRMTRCF: !!!!!!INVALID TRACE MASK!!!!!!!!: " + traceMask);
            traceMask = "XFRMTRCF";
        } else {
            char level = (traceMask = traceMask.toUpperCase()).charAt(7);
            if (level != 'T' && level != 'F' && level != 'D' && level != 'L') {
                PatchTrace.trace("XFRMTRCF: !!!!!!INVALID TRACE LEVEL!!!!!!!!: " + traceMask);
                traceMask = "XFRMTRCF";
            }
        }
        if (trace != null) {
            if (prefix == null) {
                prefix = "";
            }
            String formattedTrace = null;
            if (trace instanceof String) {
                formattedTrace = (String)trace;
            } else if (trace instanceof Throwable) {
                Throwable currentTrace = (Throwable)trace;
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                if (currentTrace != null) {
                    currentTrace.printStackTrace(printWriter);
                }
                formattedTrace = stringWriter.toString();
            } else if (attribs != null && isObjectDumperAvailable) {
                try {
                    PatchTrace.dumpObjectArgs[0] = trace;
                    PatchTrace.dumpObjectArgs[1] = attribs;
                    formattedTrace = (String)dumpObject.invoke(objectDumper, dumpObjectArgs);
                }
                catch (Exception exc) {
                    PatchTrace.trace("XFRMTRCF: !!!!!!OBJECT DUMP ERROR!!!!!!!!: " + exc);
                    formattedTrace = trace.toString();
                }
            }
            if (formattedTrace == null || formattedTrace.length() == 0) {
                formattedTrace = trace instanceof byte[] ? HexString.toHex((byte[])trace, 4, 16, true) : trace.toString();
            }
            prefix = traceMask.substring(0, 8) + ": " + prefix;
            if (formattedTrace.indexOf(10) != -1 || formattedTrace.length() > 498) {
                StringTokenizer tokenizer = new StringTokenizer(formattedTrace, "\n");
                while (tokenizer.hasMoreTokens()) {
                    String line = tokenizer.nextToken();
                    if (line.length() > 498) {
                        PatchTrace.trace(prefix + line.substring(0, 498) + "...");
                        line = line.substring(498);
                        while (line.length() > 495) {
                            PatchTrace.trace(prefix + "..." + line.substring(0, 495) + "...");
                            line = line.substring(495);
                        }
                        PatchTrace.trace(prefix + "..." + line);
                        continue;
                    }
                    PatchTrace.trace(prefix.concat(line));
                }
            } else {
                PatchTrace.trace(prefix.concat(formattedTrace));
            }
        }
    }

    public static void trace(String traceMask, String prefix, Object trace) {
        PatchTrace.trace(traceMask, prefix, trace, null);
    }

    public static void trace(String traceMask, Object trace, ObjectDumperAttributes attribs) {
        PatchTrace.trace(traceMask, "", trace, attribs);
    }

    public static void trace(String traceMask, Object trace) {
        PatchTrace.trace(traceMask, "", trace, null);
    }

    public static void createTraceFile() {
        PatchTrace.traceCommand(1);
    }

    public static void deleteTraceFile() {
        PatchTrace.traceCommand(2);
    }

    public static void flushBuffer() {
        PatchTrace.traceCommand(3);
    }

    public static void purgeBuffer() {
        PatchTrace.traceCommand(4);
    }

    public static void doneTracing() {
        PatchTrace.traceCommand(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void trace(String trace) {
        if (isLibraryLoaded) {
            Object object = traceGate;
            synchronized (object) {
                PatchTrace.XjniPatchTrace(trace);
            }
        } else {
            Trace.trace(trace.substring(0, 8), trace.substring(10));
        }
    }

    private static native void XjniPatchTrace(String var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void traceCommand(int cmd) {
        if (isLibraryLoaded) {
            Object object = traceGate;
            synchronized (object) {
                Object[] args = new Object[]{new Integer(cmd)};
                try {
                    bridge.invokeNativeFunction("iqzmcomm", "xmcm_PatchTrace_cmd", args);
                }
                catch (IOException ioe) {
                    Trace.trace("XMCLTRCF", "   The Native Bridge operation for command" + cmd + "had a communication error.");
                    new FrameworkLog(logInfo, -6830, ioe).log();
                }
                catch (NativeBridgeException nbe) {
                    Trace.trace("XMCLTRCF", "   The Native Bridge operation for command" + cmd + "had a functional error.");
                    new FrameworkLog(logInfo, -6830, nbe).log();
                }
                catch (Throwable t) {
                    Trace.trace("XMCLTRCF", "   The Native Bridge operation for command" + cmd + "had an unexpected error.");
                    new FrameworkLog(logInfo, -6830, t).log();
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logInfo = new FrameworkClassLogInfo(2, "PatchTrace");
        try {
            bridge = new NativeBridge();
            NativeProcessParameters npps = new NativeProcessParameters("actzNativeBridgeMain");
            bridge.exec(npps);
            System.loadLibrary("jniPatchTrace");
            isLibraryLoaded = true;
            PatchTrace.traceCommand(0);
        }
        catch (IOException ioe) {
            Trace.trace("XMCLTRCF", "   The native Bridge setup did not go so well.");
            new FrameworkLog(logInfo, -6831, ioe).log();
        }
        catch (Throwable e) {
            Trace.trace("XMCLTRCF", "   The jniPatchLibrary is not available.");
            new FrameworkLog(logInfo, -6832, e).log();
        }
        try {
            Class<?> objectDumperClass = Class.forName("com.ibm.hwmca.fw.util.ObjectDumper");
            objectDumper = objectDumperClass.newInstance();
            Class[] dumpObjectArgTypes = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = PatchTrace.class$("java.lang.Object")) : class$java$lang$Object, class$com$ibm$hwmca$fw$util$ObjectDumperAttributes == null ? (class$com$ibm$hwmca$fw$util$ObjectDumperAttributes = PatchTrace.class$("com.ibm.hwmca.fw.util.ObjectDumperAttributes")) : class$com$ibm$hwmca$fw$util$ObjectDumperAttributes};
            dumpObject = objectDumperClass.getMethod("dumpObject", dumpObjectArgTypes);
            isObjectDumperAvailable = true;
        }
        catch (Throwable e) {
            Trace.trace("XMCLTRCF", "   The ObjectDumper is not available.");
        }
    }
}

